package gov.va.med.mhv.health.service.impl;

import gov.va.med.mhv.health.converter.VAAllergyConverter;
import gov.va.med.mhv.health.dto.ResponseUtil;
import gov.va.med.mhv.health.dto.VAAllergyDTO;
import gov.va.med.mhv.health.model.VAAllergy;
import gov.va.med.mhv.health.repository.VAAllergyRepository;
import gov.va.med.mhv.health.service.VAAllergyService;

import java.util.List;

import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class VAAllergyServiceImpl implements VAAllergyService{
	
	private static final Logger log = LogManager.getLogger(VAAllergyServiceImpl.class);
	
	@Autowired
	private VAAllergyRepository allergyRepository;


	@Override
	public ResponseUtil findAllergiesForPatient(Long patientId) {
		ResponseUtil response = new ResponseUtil();
		List<VAAllergy> allergies=allergyRepository.getAllergiesForPatient(patientId);
		if(allergies != null){
			List<VAAllergyDTO> dtos = VAAllergyConverter.convertAllergiesRecords(allergies);
			response.setPojoObject(dtos);
		}else{
			log.debug("Allergy Records not found for Patient:");
			log.debug(patientId);
		}
		response.setSuccess(true);
		return response;
	}


	@Override
	public ResponseUtil findDashBoardVaallergiesForPatient(Long patientId) {
		ResponseUtil response = new ResponseUtil();
		Pageable topSix = new  PageRequest(0,6);
		List<VAAllergy> allergies=allergyRepository.getDashboardVaAllergiesForPatient(patientId,topSix);
		if(allergies != null){
			List<VAAllergyDTO> dtos = VAAllergyConverter.convertAllergiesRecords(allergies);
			response.setPojoObject(dtos);
		}else{
			log.debug("Dashboard VaAllergy Records not found for Patient:");
			log.debug(patientId);
		}
		response.setSuccess(true);
		return response;

	}


	@Override
	public ResponseUtil findByPrimaryKey(Long id) {
		ResponseUtil response = new ResponseUtil();
		VAAllergy vaAllergy = allergyRepository.findOne(id);
		if(vaAllergy != null){
			VAAllergyDTO vaAllergyDTO = VAAllergyConverter.convertAllergyDomain(vaAllergy);
			response.setPojoObject(vaAllergyDTO);
			response.setSuccess(true);
		}else{
			log.debug("VA Allergy record not found for id:");
			log.debug(id);
		}
		return response;
	}
}
